<?php
function themesia_assets() {
	wp_enqueue_style( 'style', get_stylesheet_uri(),false, THEMESIA_VERSION );
	if (get_option('tsrtl') == '1') {
		wp_enqueue_style('rtl', get_template_directory_uri() . '/assets/css/rtl.css', false, THEMESIA_VERSION, 'all');
	}
	wp_enqueue_style( 'darkstyle', get_template_directory_uri() . '/assets/css/darkmode.css',false, THEMESIA_VERSION,'all');
	
	wp_deregister_script('jquery');
   	wp_register_script('jquery', get_template_directory_uri() . '/assets/js/jquery.min.js', false, '3.5.1');
   	wp_enqueue_script('jquery');
	
	if(get_option('tooltip')=='1'){ wp_enqueue_script( 'qtip', get_template_directory_uri() . '/assets/js/jquery.qtip.min.js', array( 'jquery' ), '2.2.1', true ); }
	if(is_home() || is_singular('series')){
	wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array( 'jquery' ), '2.3.4', false );
	}
	if (is_single() && get_post_type() == "series"){
		wp_enqueue_script( 'blueimp', get_template_directory_uri() . '/assets/js/blueimp-gallery.min.js', array( 'jquery' ), '1.0.0', true );
	}

	if (is_single() && get_post_type() == "post"){
		wp_enqueue_script( 'reading-options', get_template_directory_uri() . '/assets/js/reading-options.js', array( 'jquery' ), THEMESIA_VERSION, true );
	}
	
	if(is_home()){ wp_enqueue_script( 'tabs', get_template_directory_uri() . '/assets/js/tabs.js', array( 'jquery' ), THEMESIA_VERSION, false ); }
	
	wp_enqueue_script( 'ts-functions', get_template_directory_uri() . '/assets/js/tsfn.js', array( 'jquery' ), THEMESIA_VERSION, false );
	
	wp_enqueue_script( 'imagesloaded', get_template_directory_uri() . '/assets/js/imagesloaded.pkg.min.js', array( 'jquery' ), '2.2.1', true );
    wp_enqueue_script( 'filter', get_template_directory_uri() . '/assets/js/filter.js', array( 'jquery' ), THEMESIA_VERSION, true );
	
	wp_enqueue_script( 'ts-events', get_template_directory_uri() . '/assets/js/tsevents.js', array( 'ts-functions' ), THEMESIA_VERSION, true );
}
add_action( 'wp_enqueue_scripts', 'themesia_assets' );

function ts_dequeue_wp_assets() {
	wp_dequeue_style( 'wp-block-library' );
    wp_dequeue_style( 'wp-block-library-theme' );
    wp_dequeue_style( 'wc-block-style' );
	wp_dequeue_style( 'global-styles' );
}
add_action( 'wp_enqueue_scripts', 'ts_dequeue_wp_assets' );

function themesia_footer_assets() {
	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/css/all.min.css',false,'5.13.0','all');
	if(get_option('tooltip')=='1'){ wp_enqueue_style( 'qtip', get_template_directory_uri() . '/assets/css/jquery.qtip.min.css',false, THEMESIA_VERSION,'all'); }
	if(is_home() || is_singular('series')){
	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.css',false,'1.0.0','all');
	}
	if (is_single() && get_post_type() == "series"){
	wp_enqueue_style( 'blueimp', get_template_directory_uri() . '/assets/css/blueimp-gallery.min.css',false,'1.0.0','all');
	}
}
add_action( 'get_footer', 'themesia_footer_assets' );

add_action ('wp_head','themesiaHeader');
function themesiaHeader(){ ?>
<link rel="preconnect" href="https://fonts.gstatic.com">
<link href="https://fonts.googleapis.com/css2?family=Fira+Sans:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">
<?php if(is_single()){ ?>
<link href="https://fonts.googleapis.com/css2?family=Merriweather:ital,wght@0,400;0,700;1,400;1,700&display=swap" rel="stylesheet">
<?php } ?>
<?php echo get_option('tsscriptheader'); ?>
<script>
	$(document).ready(function(){
		$(".shme").click(function(){
			$(".mm").toggleClass("shwx");
		});
		$(".srcmob").click(function(){
			$(".minmb").toggleClass("minmbx");
		});
		$(".gnr").click(function(){
			$(".gnrx").toggleClass("shwgx");
		});
		$(".colap").click(function(){
			$(".mindes").toggleClass("alldes");
		});
		$(".topmobile").click(function(){
			$(".topmobcon").toggleClass("topmobshow");
		});
		$(".optxid").click(function(){
			$(".optxshd").toggleClass("optxshds");
		});
	});
</script>
<?php if(is_singular('series') && get_option('styleseries')=='2'){ ?>
<script>
	$(document).ready(function(){
		if ($('.sersysn').height() > 80) {
			$('.sersysn').append('<span class="sysmore"><?php echo GOV_lang::get('synopsis_more');?></span>');
			var sysmore = $(document).find(".sysmore");
			sysmore.click(function(){
				$(".sersys").toggleClass("sersysfull");
				if($(".sersys").hasClass('sersysfull')){
					sysmore.html('<?php echo GOV_lang::get('synopsis_less');?>');
				} else {
					sysmore.html('<?php echo GOV_lang::get('synopsis_more');?>');
				}
			});
		}
	});
</script>
<?php } ?>
<?php if(get_option('tooltip')==='1'){ ?>
<script type="text/javascript">
	$(document).ready(function()
	{
	  $('.tip').each(function(){

		var $this = $(this);
		var id = $this.attr('rel');

		$this.qtip({
		  content:{
			text: '<center><img src="<?php echo get_template_directory_uri(); ?>/assets/img/loading.gif" width="30"/></center>',
			ajax:{
			  url: '<?php echo esc_url( home_url( '/' ) ); ?>wp-admin/admin-ajax.php',
			  type: 'POST', 
			  loading: false,
			  data: 'id=' + id + '&action=tooltip_action'
			}
		  },
		  show: 'mouseover',
		  hide: {
			delay: 200,
			fixed: true
		  },
		  position: {
		target: 'mouse',
		adjust: { mouse: false },
			viewport: $(window)
		  }
		});
	  });
	});
	</script>
	<?php } ?>
	<script>
	var ajaxurl = '<?php echo rtrim(get_site_url(), '/');?>/wp-admin/admin-ajax.php';
	var defaultTheme = "<?php echo get_option('defaulttheme'); ?>";
	var ts_view_count_visible = <?php echo get_option('ts_view_count', 1) ? "true" : "false"; ?>;
	const ts_lang = <?php echo json_encode(GOV_lang::front_languages()); ?>;

	<?php do_action('ts-hook-js-header'); ?>
	</script>
	<?php $tc = get_option('themecolor'); if($tc) { ?>
		<style>
			.darkmode .bxcl ul li span.dt a{background:#30353c;}
			.th,.trendarea .trendlist .trendinf .cusinfo .cusi.toptype a,.soraddlx .sorattlx,.releases .vl,.serieslist.pop ul li.topone .limit .bw .ctr,#footer .footermenu,.bigcontent .infox .spe span:before,.commentx #submit,.naveps .nvsc a,.radiox input:checked ~ .checkmarkx,.advancedsearch button.searchz,.lista a:hover,.bxcl ul li span.dt a:hover,.bookmark,.bs .bsx .limit .typez.Drama,.hpage a,.darkmode .naveps .nvsc a,.darkmode .lista a,.darkmode .nav_apb a:hover,#sidebar .section ul.season li:before,#sidebar .section ul.season::-webkit-scrollbar-thumb,#sidebar .section .ongoingseries ul li a .l .fa, #sidebar .section .ongoingseries ul li a .r,.releases.latesthome,.quickfilter .filters .filter.submit button,.footer-az .az-list li a,.stylesix .bsx .upscore,.stylefor .bsx .tt span i,.soraddlx .soraurlx strong,.bxcl ul li:hover,.darkmode .quickfilter .filters .filter.submit button,.darkmode .bxcl ul li:hover,#sidebar .section .ongoingseries ul::-webkit-scrollbar-thumb,.bxcl ul::-webkit-scrollbar-thumb,.bigcontent .infox .genxed a:hover,.lastend .inepcx a,.single-info.bixbox .infox .spe span:before,.single-info.bixbox .infox .genxed a:hover,.series-gen .nav-tabs li.active a,.naveps.bignav .nvs.nvsc a,.darkmode .naveps.bignav .nvs.nvsc a,#top-menu li a:hover,.topmobile,.comment-list .comment-body .reply a:hover,.bixbox.bxcl.epcheck .ts-chl-collapsible,.homehot .hotstack .hotoday .inhotoday .todinfo .todsco .todtext,.bloglist .blogbox .innerblog .thumb .btags,.ingfo .minginfo span.r,#sidebar .section .ts-wpop-series-gen .ts-wpop-nav-tabs li.active span,.darkmode .bxcl .series-history-pool ul li .chbox:hover,.bxcl .series-history-pool ul li .chbox:hover{background:<?php echo $tc; ?>;}
			.pagination span.page-numbers.current,#gallery.owl-loaded .owl-dots .owl-dot.active span,.taxindex li a:hover,.darkmode .quickfilter .filters .filter.submit button{background:<?php echo $tc; ?> !important;}
			.releases span,.advancedsearch button.searchz,.lista a:hover,.darkmode .lista a,.stylefor .bsx:hover,.bxcl ul li:hover,.single-info.bixbox .infox .genxed a:hover,.comment-list .comment-body .reply a,.homehot .hotstack .hotoday .inhotoday .todinfo .todsco .todnum {border-color:<?php echo $tc; ?>;}
			.surprise:hover {color: #FFF;background: #333;}
			a:hover,.listupd .lexa .dtl h2 a:hover,.live-search_result_container a:hover,.footer-az .az-list li a:hover,.bxcl ul li span.dt a .dashicons .darkmode #sidebar .section .serieslist ul li .leftseries span a,.stylefor a:hover,.seventh .main-seven .tt .sosev span a:hover,.stylesix .bsx .inf span a,.epl-num a,.bixbox.episodedl .epwrapper .epheader .entry-info a,.darkmode a:hover,.dlbox ul li span a,.single-info.bixbox .infox .infolimit h2,.bs .bsx .tt span.nchapter,.listupd .utao .uta .luf ul li,.bixbox.episodedl .epwrapper .epheader h1,.comment-list .comment-body .reply a,.bxcl ul li a:visited,.homehot .hotstack .hotoday .inhotoday .todinfo .todsco .todnum,.stylefor .med-info .col-chap .forchap a,.maindet .inmain .mdinfo .mdgenre a,.maindet .inmain .mdinfo .mdinfodet a,.bigcontent .infox .spe span a,.single-info.bixbox .infox a,.darkmode .single-info.bixbox .infox a:hover,.darkmode .seriestwo .sertobig .insertobig .sertoinfo .sertoauth .serl a:hover,.darkmode .meta .year a:hover,.darkmode .blogpost .entry-header .entry-meta a:hover,.darkmode .cmt .must-log-in a:hover,.darkmode .bigcontent .infox .spe span a:hover {color:<?php echo $tc; ?>;}
			.footer-az .az-list li a:hover{color:<?php echo $tc; ?> !important;}
			.releases h1,.releases h3,#sidebar .section h4 {color:#333}
			.bs .bsx .limit .ply {background:rgba(0,0,0,0.5);}
			.serieslist ul li .ctr,.bigcontent .infox .genxed a,.single-info.bixbox .infox .genxed a{color:<?php echo $tc; ?>;border-color:<?php echo $tc; ?>;}
			.darkmode .bigcontent .infox .genxed a,.darkmode .single-info.bixbox .infox .genxed a{color:#CCC}
			.darkmode .bigcontent .infox .genxed a:hover,.darkmode .single-info.bixbox .infox .genxed a:hover,.darkmode .single-info.bixbox .infox .infolimit h2{color:#FFF}
			.modex a {background: #333;}
			.modex a:hover,.stylefor .bsx .tt span i,.darkmode .naveps.bignav .nvs.nvsc a {color: #FFF;}
			.bigcontent .rt .rating,.bxcl ul li span.dt a{background: #f8f8f8;}
			.bookmark:hover{background:#1d1b26}
			.darkmode .lista a:hover,.slider:before{background:#333}
			@media only screen and (max-width: 800px){
				.th,.darkmode .th{background:<?php echo $tc; ?>;}
				#main-menu{background:rgba(28,28,28,.95);}
				.surprise{background:<?php echo $tc; ?>;}
			}
		</style>
	<?php } ?>
	<?php $hc = get_option('hotupdatecolor'); if($hc) { ?><style>.releases.hothome{background:<?php echo $hc; ?>;}</style><?php } ?>
	
<?php }

add_action ('wp_footer','themesiaFooter');
function themesiaFooter(){ ?>
<?php if(is_singular('series')){ ?>
<script>
	$('.owl-carousel').owlCarousel({
		stagePadding: 50,
		loop:true,
		margin:10,
		responsive:{
			0:{
				items:1
			},
			600:{
				items:4
			},
			1000:{
				items:4
			}
		}
	});
	var isGalleryDragging = false;
	$("#gallery").on("mousedown touchstart", function() {
		isGalleryDragging = false;
	}).on("mousemove touchmove", function() {
		isGalleryDragging = true;
	}).on("mouseup touchend", function(event) {
		event.preventDefault();
		var wasGallerDragging = isGalleryDragging;
		isGalleryDragging = false;
		if (!wasGallerDragging) {
			event = event || window.event;
			var target = event.target || event.srcElement;
			var link = target.src ? target.parentNode : target;
			var options = { index: link, event: event };
			var links = this.getElementsByTagName('a');
			blueimp.Gallery(links, options);
		}
	});
	$("#gallery a").on("click", function(){return false;});
</script>
<div id="blueimp-gallery" class="blueimp-gallery blueimp-gallery-controls">
      <div class="slides"></div>
      <h3 class="title"></h3>
      <span class="prev">‹</span>
      <span class="next">›</span>
      <span class="close">×</span>
      <span class="play-pause"></span>
      <ol class="indicator"></ol>
</div>
<?php } ?>
<?php if(is_single()){ get_template_part('template-parts/single/option-read'); } ?>
<?php floating(); ?>
<script>
jQuery("#thememode input[type='checkbox']").on('change', function(){
	var is_on = jQuery("#thememode input[type='checkbox']").prop("checked");
	if (is_on == false){
		localStorage.setItem("thememode", "lightmode");
		jQuery("body").addClass("lightmode");
		jQuery("body").removeClass("darkmode");
	}else{
		localStorage.setItem("thememode", "darkmode");
		jQuery("body").removeClass("lightmode");
		jQuery("body").addClass("darkmode");
	}
});
</script>
<?php echo get_option('tsscriptfooter'); ?>

<script>
jQuery.event.special.touchstart = {
    setup: function( _, ns, handle ) {
        this.addEventListener("touchstart", handle, { passive: !ns.includes("noPreventDefault") });
    }
};
jQuery.event.special.touchmove = {
    setup: function( _, ns, handle ) {
        this.addEventListener("touchmove", handle, { passive: !ns.includes("noPreventDefault") });
    }
};
jQuery.event.special.wheel = {
    setup: function( _, ns, handle ){
        this.addEventListener("wheel", handle, { passive: true });
    }
};
jQuery.event.special.mousewheel = {
    setup: function( _, ns, handle ){
        this.addEventListener("mousewheel", handle, { passive: true });
    }
};
</script>
<?php } 

add_action( 'rwmb_enqueue_scripts', function(){
	global $post_type;
	if ($post_type != "series") return;
	wp_enqueue_script( 'ts_ae_generate_series_data', get_template_directory_uri() . '/assets/js/generate-series.js', array( 'jquery' ), THEMESIA_VERSION, true );
} );

add_filter('manage_post_posts_columns', 'add_ts_views_column');
add_filter('manage_series_posts_columns', 'add_ts_views_column');
add_action('manage_post_posts_custom_column', 'add_ts_views_column_content');
add_action('manage_series_posts_custom_column', 'add_ts_views_column_content');
function add_ts_views_column($defaults) {
	$defaults['ts-views'] = __( 'Views', 'ts_post_views' );
	return $defaults;
}

function add_ts_views_column_content($column_name) {
	if ($column_name === 'ts-views' ) {
		echo get_post_meta(get_the_ID(),'wpb_post_views_count',true);
	}
}

add_filter( 'manage_edit-post_sortable_columns', 'sort_ts_postviews_column');
add_filter( 'manage_edit-series_sortable_columns', 'sort_ts_postviews_column' );
function sort_ts_postviews_column( $defaults ) {
	$defaults['ts-views'] = 'views';
	return $defaults;
}
add_action('pre_get_posts', 'sort_ts_views');
function sort_ts_views($query) {
	if ( ! is_admin() ) {
		return;
	}
	$orderby = $query->get('orderby');
	if ( 'views' === $orderby ) {
		$query->set( 'meta_key', 'wpb_post_views_count' );
		$query->set( 'orderby', 'meta_value_num' );
	}
}
add_filter('GOV-popular>>trending-final-args', "ts_lightnovel_more_trending");
function ts_lightnovel_more_trending($args){
	$args['showposts'] = 2;
	$args['posts_per_page'] = 2;
	return $args;
}


ts_core_hooks();