jQuery('button.sg-generate').on('click', function(){
    if (jQuery(this).attr('data-is-running') == "1") return;
    jQuery("button.sg-generate").html("Loading..");
    jQuery(this).attr('data-is-running', 1);
    var input = jQuery('#ero_series_generate').val().trim();
    if ( ! input) return;
    var lang = jQuery('#ero_generate_desc_lang').val();
    if (lang) localStorage.setItem('tsed_lastlang', lang);
    var url = "https://api.themesia.com/novelupdates/";
    jQuery.getJSON(url, {"url": input})
    .done(function(json){
        if (typeof(json) !== typeof({})) return console.log("Invalid data received");
        if (json === null) return console.log("Invalid data received");
        if (json.error){
            if (json.data !== 'Pending') return;
            setTimeout(function(){
                jQuery("button.sg-generate").attr('data-is-running', "");
                jQuery('button.sg-generate').trigger('click');
            }, 2000);
            return;
        }
        if (jQuery("#content-html").length) jQuery("#content-html").trigger('click');
        var data = json.data;
        if (data.title && jQuery("input#title").length){
            jQuery("input#title").val(data.title);
            jQuery("label#title-prompt-text").addClass('screen-reader-text');
        }

        if (data.description[lang] && jQuery('textarea#content').length){
            jQuery('textarea#content').val(data.description[lang]);
        }else if(data.description.default && jQuery('textarea#content').length){
            jQuery('textarea#content').val(data.description.default);
        }

        if (data.tags && jQuery('input#new-tag-post_tag').length){
            jQuery('input#new-tag-post_tag').val(data.tags);
            jQuery('input#new-tag-post_tag').siblings('input.tagadd').trigger('click');
        }
        if (data.genres && jQuery('input#new-tag-genre').length){
            jQuery('input#new-tag-genre').val(data.genres);
            jQuery('input#new-tag-genre').siblings('input.tagadd').trigger('click');
        }
        if (data.type && jQuery('input#new-tag-type').length){
            jQuery('input#new-tag-type').val(data.type);
            jQuery('input#new-tag-type').siblings('input.tagadd').trigger('click');
        }
        if (data.authors && jQuery('input#new-tag-writer').length){
            jQuery('input#new-tag-writer').val(data.authors);
            jQuery('input#new-tag-writer').siblings('input.tagadd').trigger('click');
        }
        if (data.artists && jQuery('input#new-tag-artist').length){
            jQuery('input#new-tag-artist').val(data.artists);
            jQuery('input#new-tag-artist').siblings('input.tagadd').trigger('click');
        }
        if (data.alternatives && jQuery("input#ero_lang").length){
            jQuery("input#ero_alt").val(data.alternatives);
        }
        if (data.language && jQuery("input#ero_lang").length){
            jQuery("input#ero_lang").val(data.language);
        }
        if (data.year && jQuery("input#ero_date").length){
            jQuery("input#ero_date").val(data.year);
        }
        if (data.rating && jQuery("input#ero_score").length){
            jQuery("input#ero_score").val(data.rating);
        }
        if (data.image && jQuery("input#ero_image").length){
            jQuery("input#ero_image").val(data.image);
        }
        jQuery("button.sg-generate").html("Generate");
        jQuery("button.sg-generate").attr('data-is-running', "");
        setTimeout(function(){
            jQuery("input#title").get(0).scrollIntoView({behavior: "smooth", block: "end", inline: "nearest"});
        }, 100);

    })
    .fail(function(){
        console.log('API server error!');
        jQuery("button.sg-generate").attr('data-is-running', "");
        jQuery("button.sg-generate").html("Generate");
    });
});
jQuery(document).ready(function(){
    var postStatus = jQuery('input#original_post_status').val();
    if (postStatus != 'auto-draft'){
        jQuery('#autogenerateimgcat').hide();
    }
    if (jQuery('#ero_generate_desc_lang').length){
        var lastSelectedLang = localStorage.getItem('tsed_lastlang');
        if (lastSelectedLang){
            jQuery('#ero_generate_desc_lang').val(lastSelectedLang);
        }
    }
});