var ts_reading_options = {
	lsname: "ts_rs_cfg",
	default_cfg: {
		"fontSize": "16px",
		"fontFamily": "'Fira Sans', sans-serif",
		"lineHeight": "160%",
		"background": "#FFF"
	},
};
ts_reading_options.is_supported = function(){
	return "localStorage" in window;
}
ts_reading_options.valid_configs = function(configs){
	if (typeof(configs) != "object" || configs == null) return false;
	if ("fontSize" in configs == false) return false;
	if ("fontFamily" in configs == false) return false;
	if ("lineHeight" in configs == false) return false;
	if ("background" in configs == false) return false;
	return true;
}
ts_reading_options.configs = function(){
	var default_cfg = this.default_cfg;
	if ( ! this.is_supported()) return default_cfg;
	var data = localStorage.getItem(this.lsname);
	if (data == null) return default_cfg;
	try{
		data = JSON.parse(data);
	}catch(e){
		return default_cfg;
	}
	return data;
}
ts_reading_options.save_configs = function(configs){
	if ( ! this.is_supported()) return false;
	if ( ! this.valid_configs(configs)) return  false;
	localStorage.setItem(this.lsname, JSON.stringify(configs));
}
ts_reading_options.set_config = function(key, value){
	if ( ! this.is_supported()) return false;
	var configs = this.configs();
	if (key in configs == false) return false;
	configs[key] = value;
	return this.save_configs(configs);
}
ts_reading_options.get_config = function(key){
	if ( ! this.is_supported()) return false;
	var configs = this.configs();
	if ( ! this.valid_configs(configs)) return  false;
	if (key in configs) return configs[key];
	return false;
}
ts_reading_options.reset = function(){
	window.localStorage.setItem(this.lsname, JSON.stringify(this.default_cfg));
	jQuery(document).find('.optxshd #option-background').val(this.default_cfg.background).trigger("change");
	jQuery(document).find('.optxshd #option-font-family').val(this.default_cfg.fontFamily).trigger("change");
	jQuery(document).find('.optxshd #option-font-size').val(this.default_cfg.fontSize).trigger("change");
	jQuery(document).find('.optxshd #option-line-height').val(this.default_cfg.lineHeight).trigger("change");
}
ts_reading_options.init = function(){
	var configs = this.configs();
	if (configs.fontSize){
		jQuery(".postbody .bixbox .epcontent.entry-content").css('font-size', configs.fontSize); 
		jQuery("#option-font-size").val(configs.fontSize);
	}
	if (configs.fontFamily){
		jQuery(".postbody .bixbox .epcontent.entry-content").css('font-family', configs.fontFamily);
		jQuery("#option-font-family").val(configs.fontFamily);
	}
	if (configs.lineHeight){
		jQuery(".postbody .bixbox .epcontent.entry-content").css('line-height', configs.lineHeight);
		jQuery("#option-line-height").val(configs.lineHeight);
	} 
	if (configs.background){
		jQuery(".postbody .bixbox.episodedl").css('background-color', configs.background);
		jQuery(".postbody .bixbox.episodedl .navimedia").css('background-color', configs.background);
		jQuery("#option-background").val(configs.background);
	} 
}
ts_reading_options.events = function(){
	jQuery(document).on('change', '.optxshd #option-background', function(event){
		var is_darkmode = jQuery("#thememode input[type='checkbox']").prop("checked");
		if ( ! is_darkmode && "localStorage" in window && localStorage.getItem('thememode') === 'darkmode'){
			is_darkmode = true;
		}
		if (is_darkmode) return false;
		jQuery(".postbody .bixbox.episodedl").css('background-color', this.value);
		jQuery(".postbody .bixbox.episodedl .navimedia").css('background-color', this.value);
		ts_reading_options.set_config("background", this.value);
	});
	jQuery(document).on('change', '.optxshd #option-font-family', function(event){
		jQuery(".postbody .bixbox .epcontent.entry-content").css('font-family', this.value);
		ts_reading_options.set_config("fontFamily", this.value);
	});
	jQuery(document).on('change', '.optxshd #option-font-size', function(event){
		jQuery(".postbody .bixbox .epcontent.entry-content").css('font-size', this.value);
		ts_reading_options.set_config("fontSize", this.value);
	});
	jQuery(document).on('change', '.optxshd #option-line-height', function(event){
		jQuery(".postbody .bixbox .epcontent.entry-content").css('line-height', this.value);
		ts_reading_options.set_config("lineHeight", this.value);
	});
	jQuery(document).on('click', '.optxshd #optrst', function(event){
		ts_reading_options.reset();
	});
};